﻿/****** Object:  StoredProcedure [puma].[PatientMasterOverrideSave]    Script Date: 06/20/2013 10:12:00 ******/
DROP PROCEDURE [puma].[PatientMasterOverrideSave]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date: 6 Dec 2012
-- Description:   Inserts/Updates a record into the Patient Master Override Table
-- =============================================
CREATE PROCEDURE [puma].[PatientMasterOverrideSave] 
(
	@PatientMasterId INT,
	@DateOfBirth DATETIME = NULL,
	@MedicareNumber VARCHAR(12) = NULL,
	@MedicareIrn VARCHAR(3) = NULL,
	@IsMedicareNumberValid BIT = NULL,
	@DvaNumber VARCHAR(18) = NULL,
	@DateModified DATETIME,
	@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON

	DECLARE @DoesExist INT
    DECLARE @intErrorCode INT

    SET @intErrorCode = 0
    -- First see if we have an existing record      
    SELECT Top 1 @DoesExist =  pmo.PatientMasterId
    FROM [puma].PatientMasterOverride pmo
    WHERE pmo.PatientMasterId = @PatientMasterId
    
    -- No it does not. Insert a new one
    IF (@DoesExist IS NULL)
    BEGIN
    	INSERT INTO [puma].PatientMasterOverride
	        ( PatientMasterId,
	          DateOfBirth,
	          MedicareNumber,
	          MedicareIrn,
	          IsMedicareNumberValid,
	          DvaNumber,
	          DateCreated,
	          UserCreated,
	          DateModified,
	          UserModified
	        )
			VALUES  (	@PatientMasterId,
						@DateOfBirth,
						@MedicareNumber,
						@MedicareIrn,
						@IsMedicareNumberValid,
						@DvaNumber,
						GETDATE(),
						@UserModified,
						GETDATE(),
						@UserModified
			
					)
			SELECT @intErrorCode = @@ERROR
    END
    
    -- Yes it does, update the new values
    ELSE BEGIN
			UPDATE [puma].PatientMasterOverride
			SET  DateOfBirth = @DateOfBirth		  
				,MedicareNumber = @MedicareNumber	
				,MedicareIrn = @MedicareIrn	 
				,IsMedicareNumberValid = @IsMedicareNumberValid
				,DvaNumber = @DvaNumber
				,[DateModified] = GetDate()
				,[UserModified] = @UserModified
           WHERE  PatientMasterId = @PatientMasterId
        SELECT @intErrorCode = @@ERROR
    END
        
    IF @intErrorCode = 0
    BEGIN
		SELECT pmo.PatientMasterId,
				pmo.DateOfBirth,
				pmo.MedicareNumber,
				pmo.MedicareIrn,
				pmo.IsMedicareNumberValid,
				pmo.DvaNumber,
				pmo.UserCreated,
				pmo.DateCreated,
				pmo.UserModified,
				pmo.DateModified
				
		FROM [puma].[PatientMasterOverride] AS pmo
    END

   RETURN(@intErrorCode)
END
GO
